using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using System.Resources;
using System.Text;
using Microsoft.ContentManagement.Publishing;

namespace ContosoNet.Site_Templates
{
	/// <summary>
	/// Summary description for BaseTemplate.
	/// </summary>
	public class NewsArchives : System.Web.UI.Page
	{
		protected LocalizationManager localizationManager;
		protected Microsoft.ContentManagement.WebControls.HtmlPlaceholderControl QuotePlaceholder;
		protected System.Web.UI.WebControls.Literal NewsListingsLiteral;
		protected Telerik.WebControls.RadEditorPlaceHolderControl GeneralCopyPlaceholder;
		protected System.Web.UI.WebControls.Label RssLabel;
		protected Microsoft.ContentManagement.WebControls.RobotMetaTag RobotMetaTag1;

		private void Page_Load(object sender, System.EventArgs e)
		{
			localizationManager = new LocalizationManager ();
			RssLabel.Text = localizationManager.GetString ("rssFeed");

			Channel newsChannel = 
				SiteUtils.GetChannel (SiteValues.ExternalPressReleasesChannelPath);
			PostingCollection myPostings = newsChannel.Postings;
			myPostings.SortByStartDate(false);

			StringBuilder htmlString = new StringBuilder();
			htmlString.Append ("<ul>");
			foreach (Posting p in myPostings)
			{
				if (p.Name.ToLower() != "default")
				{
					EnsureHeading (p, htmlString);
					htmlString.Append ("<li><a href=\"");
					htmlString.Append (p.Url);
					htmlString.Append ("\">");
					htmlString.Append (p.DisplayName);
					htmlString.Append ("</a> (");
					htmlString.Append (p.StartDate.ToShortDateString());
					htmlString.Append (")");
				}
			}
			htmlString.Append ("</ul>");

			NewsListingsLiteral.Text = htmlString.ToString();
		}

		private static DateTime lastHeading;
		private void EnsureHeading (Posting p, StringBuilder htmlString)
		{
			if ((p.StartDate.Year != lastHeading.Year) ||
				(p.StartDate.Month != lastHeading.Month))
			{
				// The year or month have changed. We want to include
				// a heading.
				string monthyear = p.StartDate.ToString("MMMM, yyyy");
				htmlString.Append ("</ul>");
				htmlString.Append ("<h3>News for " + monthyear + "</h3>");
				htmlString.Append ("<ul>");

				lastHeading = p.StartDate;
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
